/*
 * Decompiled with CFR 0.152.
 */
package o7410.bundlesbeyond;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.Strictness;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Function;
import net.fabricmc.loader.api.FabricLoader;
import o7410.bundlesbeyond.BundlesBeyond;
import o7410.bundlesbeyond.ModEnabledState;
import o7410.bundlesbeyond.ScrollMode;
import org.slf4j.Logger;

public class BundlesBeyondConfig {
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("bundles_beyond.json");
    private static final Gson GSON = new GsonBuilder().setStrictness(Strictness.STRICT).setPrettyPrinting().create();
    private static BundlesBeyondConfig instance = new BundlesBeyondConfig();
    public ScrollMode scrollMode = ScrollMode.VANILLA;
    public ModEnabledState modEnabledState = ModEnabledState.ON;
    public int slotSize = 24;
    private static final Codec<Integer> BUNDLE_SLOT_SIZE_CODEC = Codec.INT.comapFlatMap(integer -> integer >= 18 && integer <= 24 ? DataResult.success((Object)integer) : DataResult.error(() -> "slotSize must be between 18 and 24, found " + integer), Function.identity());
    private static final Codec<BundlesBeyondConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ScrollMode.CODEC.fieldOf("scrollMode").forGetter(config -> config.scrollMode), (App)ModEnabledState.CODEC.fieldOf("modEnabledState").forGetter(config -> config.modEnabledState), (App)BUNDLE_SLOT_SIZE_CODEC.fieldOf("slotSize").forGetter(config -> config.slotSize)).apply((Applicative)instance, (scrollMode, modEnabledState, slotSize) -> {
        BundlesBeyondConfig config = new BundlesBeyondConfig();
        config.scrollMode = scrollMode;
        config.modEnabledState = modEnabledState;
        config.slotSize = slotSize;
        return config;
    }));

    public static BundlesBeyondConfig instance() {
        return instance;
    }

    public static boolean save() {
        boolean bl;
        block8: {
            BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);
            try {
                BundlesBeyond.LOGGER.info("Writing config to file");
                GSON.toJson((JsonElement)BundlesBeyondConfig.toJson(), (Appendable)writer);
                bl = true;
                if (writer == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonIOException | IOException | SecurityException e) {
                    BundlesBeyond.LOGGER.error("Error writing config to file: {}", (Object)e.toString());
                    return false;
                }
            }
            writer.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean load() {
        try {
            if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
                BundlesBeyond.LOGGER.info("Creating config file in '{}'", (Object)CONFIG_PATH);
                BundlesBeyondConfig.save();
                return true;
            }
            BundlesBeyond.LOGGER.info("Reading config from file");
            try {
                BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);
                try {
                    BundlesBeyondConfig config;
                    JsonObject rawConfig;
                    try {
                        rawConfig = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                    }
                    catch (JsonSyntaxException e) {
                        BundlesBeyond.LOGGER.error("Error reading config from file: {}", (Object)e.toString());
                        BundlesBeyondConfig.save();
                        boolean bl = false;
                        if (reader == null) return bl;
                        reader.close();
                        return bl;
                    }
                    if (rawConfig.has("scrollAxisKeybindMode")) {
                        BundlesBeyond.LOGGER.info("Migrating old config");
                        BundlesBeyondConfig.migrateOldConfig(rawConfig);
                    }
                    if ((config = BundlesBeyondConfig.fromJson(rawConfig)) == null) {
                        boolean bl = false;
                        return bl;
                    }
                    instance = config;
                    boolean bl = true;
                    return bl;
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2;
                            throwable2.addSuppressed(throwable);
                        }
                    }
                }
            }
            catch (JsonIOException | IOException e) {
                BundlesBeyond.LOGGER.error("Error reading config from file: {}", (Object)e.toString());
                return false;
            }
        }
        catch (SecurityException e) {
            BundlesBeyond.LOGGER.error("Error reading config from file: {}", (Object)e.toString());
            return false;
        }
    }

    private static BundlesBeyondConfig fromJson(JsonObject jsonObject) {
        return CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).resultOrPartial(arg_0 -> ((Logger)BundlesBeyond.LOGGER).error(arg_0)).orElse(null);
    }

    private static JsonObject toJson() {
        return ((JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)instance).getOrThrow()).getAsJsonObject();
    }

    private static void migrateOldConfig(JsonObject config) {
        if (config.has("scrollAxisKeybindMode")) {
            String oldScrollMode = config.get("scrollAxisKeybindMode").getAsString();
            if ("toggle".equals(oldScrollMode)) {
                boolean isHorizontal = config.has("scrollingToggledHorizontal") && config.get("scrollingToggledHorizontal").getAsBoolean();
                config.addProperty("scrollMode", isHorizontal ? "horizontal" : "vertical");
            }
            config.remove("scrollAxisKeybindMode");
            config.remove("scrollingToggledHorizontal");
        }
        if (config.has("modEnabledKeyModeOnToggle") && !config.get("modEnabledKeyModeOnToggle").getAsBoolean()) {
            config.addProperty("modEnabledState", "hold_key");
        } else {
            boolean isOn = config.has("modEnabledWhenOnToggle") && config.get("modEnabledWhenOnToggle").getAsBoolean();
            config.addProperty("modEnabledState", isOn ? "on" : "off");
        }
        config.remove("modEnabledKeyModeOnToggle");
        config.remove("modEnabledWhenOnToggle");
    }
}

