/*
 * Decompiled with CFR 0.152.
 */
package o7410.bundlesbeyond;

import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5537;
import net.minecraft.class_746;
import o7410.bundlesbeyond.BundlesBeyond;
import o7410.bundlesbeyond.BundlesBeyondConfig;
import o7410.bundlesbeyond.ModEnabledState;
import o7410.bundlesbeyond.ScrollMode;
import o7410.bundlesbeyond.mixin.HandledScreenAccessor;

public class BundleTooltipAdditions {
    public static boolean handleKeybindsInBundleGui(class_1735 slot, int keyCode) {
        class_1799 stack = slot.method_7677();
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        if (player == null) {
            return false;
        }
        BundlesBeyondConfig config = BundlesBeyondConfig.instance();
        if (config.modEnabledState != ModEnabledState.HOLD_KEY && keyCode == BundlesBeyond.getKeyCode(BundlesBeyond.MOD_ENABLED_KEY)) {
            config.modEnabledState = config.modEnabledState == ModEnabledState.ON ? ModEnabledState.OFF : ModEnabledState.ON;
            BundlesBeyondConfig.save();
            player.method_7353((class_2561)class_2561.method_43470((String)("Bundles Beyond " + (config.modEnabledState == ModEnabledState.ON ? "enabled" : "disabled"))), true);
            int selectedIndex = class_5537.method_61643((class_1799)stack);
            if (config.modEnabledState == ModEnabledState.ON) {
                return true;
            }
            int shownStacksWhenDisabled = class_5537.method_61645((class_1799)stack);
            if (selectedIndex >= shownStacksWhenDisabled) {
                selectedIndex = -1;
                class_5537.method_61637((class_1799)stack, (int)selectedIndex);
                BundlesBeyond.sendBundleSelectedPacket(slot.field_7874, selectedIndex);
            }
            return true;
        }
        if (!BundlesBeyond.isModEnabled()) {
            return false;
        }
        if ((config.scrollMode == ScrollMode.HORIZONTAL || config.scrollMode == ScrollMode.VERTICAL) && keyCode == BundlesBeyond.getKeyCode(BundlesBeyond.SCROLL_AXIS_KEY)) {
            config.scrollMode = config.scrollMode == ScrollMode.HORIZONTAL ? ScrollMode.VERTICAL : ScrollMode.HORIZONTAL;
            BundlesBeyondConfig.save();
            player.method_7353((class_2561)class_2561.method_43470((String)("Now scrolling " + (config.scrollMode == ScrollMode.HORIZONTAL ? "horizontally" : "vertically"))), true);
            return true;
        }
        if (keyCode == 32) {
            class_437 shownStacksWhenDisabled = client.field_1755;
            if (shownStacksWhenDisabled instanceof class_465) {
                class_465 handledScreen = (class_465)shownStacksWhenDisabled;
                class_1703 currentScreenHandler = player.field_7512;
                int button = currentScreenHandler.method_34255().method_7960() ? 1 : 0;
                ((HandledScreenAccessor)handledScreen).callOnMouseClick(slot, slot.field_7874, button, class_1713.field_7790);
            }
            return true;
        }
        switch (keyCode) {
            case 61: 
            case 334: {
                if (config.slotSize >= 24) break;
                String message = "Slot size is now: " + ++config.slotSize + (config.slotSize == 24 ? " (Vanilla)" : "");
                player.method_7353((class_2561)class_2561.method_43470((String)message), true);
                BundlesBeyondConfig.save();
                break;
            }
            case 45: 
            case 333: {
                if (config.slotSize <= 18) break;
                String message = "Slot size is now: " + --config.slotSize + (config.slotSize == 24 ? " (Vanilla)" : "");
                player.method_7353((class_2561)class_2561.method_43470((String)message), true);
                BundlesBeyondConfig.save();
            }
        }
        int selectedIndex = class_5537.method_61643((class_1799)stack);
        int size = class_5537.method_61645((class_1799)stack);
        if (size == 0) {
            return false;
        }
        int width = BundleTooltipAdditions.getModifiedBundleTooltipColumns(size);
        int height = BundleTooltipAdditions.getModifiedBundleTooltipRows(size, width);
        class_315 gameOptions = client.field_1690;
        int forwardCode = BundlesBeyond.getKeyCode(gameOptions.field_1894);
        int leftCode = BundlesBeyond.getKeyCode(gameOptions.field_1913);
        int backCode = BundlesBeyond.getKeyCode(gameOptions.field_1881);
        int rightCode = BundlesBeyond.getKeyCode(gameOptions.field_1849);
        if (keyCode == forwardCode || keyCode == 265) {
            selectedIndex = BundleTooltipAdditions.offsetVertical(size, width, height, selectedIndex, -1);
        } else if (keyCode == leftCode || keyCode == 263) {
            selectedIndex = BundleTooltipAdditions.offsetHorizontal(size, width, height, selectedIndex, -1);
        } else if (keyCode == backCode || keyCode == 264) {
            selectedIndex = BundleTooltipAdditions.offsetVertical(size, width, height, selectedIndex, 1);
        } else if (keyCode == rightCode || keyCode == 262) {
            selectedIndex = BundleTooltipAdditions.offsetHorizontal(size, width, height, selectedIndex, 1);
        } else {
            return false;
        }
        if (selectedIndex == -1) {
            return false;
        }
        class_5537.method_61637((class_1799)stack, (int)selectedIndex);
        BundlesBeyond.sendBundleSelectedPacket(slot.field_7874, selectedIndex);
        return true;
    }

    public static int offsetVertical(int size, int width, int height, int selectedIndex, int offset) {
        if (height == 1) {
            return selectedIndex == -1 ? 0 : -1;
        }
        if (selectedIndex == -1) {
            selectedIndex = 0;
        }
        int emptySlotsAtTheStart = width * height - size;
        int gridIndex = selectedIndex + emptySlotsAtTheStart;
        int gridX = gridIndex % width;
        int gridY = gridIndex / width;
        if ((gridY += offset) < 0) {
            gridY += height;
        }
        if (gridY >= height) {
            gridY -= height;
        }
        if (gridY == 0 && gridX < emptySlotsAtTheStart) {
            if (height == 2) {
                return -1;
            }
            if ((gridY += offset) < 0) {
                gridY += height;
            }
        }
        gridIndex = gridY * width + gridX;
        selectedIndex = gridIndex - emptySlotsAtTheStart;
        return selectedIndex;
    }

    public static int offsetHorizontal(int size, int width, int height, int selectedIndex, int offset) {
        int indexInRow;
        int thisRowWidth;
        if (size == 1) {
            return selectedIndex == 0 ? -1 : 0;
        }
        int emptySlotsAtTheStart = width * height - size;
        int gridIndex = selectedIndex + emptySlotsAtTheStart;
        int gridX = gridIndex % width;
        boolean isFirstRow = selectedIndex < width - emptySlotsAtTheStart;
        int n = thisRowWidth = isFirstRow ? width - emptySlotsAtTheStart : width;
        if (thisRowWidth == 1) {
            return selectedIndex == 0 ? -1 : 0;
        }
        int n2 = indexInRow = isFirstRow ? selectedIndex : gridX;
        if ((indexInRow += offset) < 0) {
            indexInRow = thisRowWidth - 1;
        }
        if (indexInRow >= thisRowWidth) {
            indexInRow = 0;
        }
        gridX = isFirstRow ? indexInRow + emptySlotsAtTheStart : indexInRow;
        gridIndex = gridIndex / width * width + gridX;
        selectedIndex = gridIndex - emptySlotsAtTheStart;
        return selectedIndex;
    }

    public static int getModifiedBundleTooltipColumns(int size) {
        return Math.max(4, class_3532.method_15384((double)Math.sqrt(size)));
    }

    public static int getModifiedBundleTooltipColumnsPixels(int size) {
        return BundleTooltipAdditions.getModifiedBundleTooltipColumns(size) * BundlesBeyondConfig.instance().slotSize;
    }

    public static int getModifiedBundleTooltipRows(int size, int columns) {
        return class_3532.method_38788((int)size, (int)columns);
    }
}

