/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.scribble.history;

import java.util.ArrayList;
import java.util.List;
import me.chrr.scribble.Scribble;
import me.chrr.scribble.history.HistoryListener;
import me.chrr.scribble.history.command.Command;

public class CommandManager {
    private final HistoryListener listener;
    private final List<Command> commands = new ArrayList<Command>();
    private int index = 0;

    public CommandManager(HistoryListener listener) {
        this.listener = listener;
    }

    public void push(Command command) {
        while (this.index < this.commands.size()) {
            this.commands.removeLast();
        }
        this.commands.add(command);
        ++this.index;
        if (this.commands.size() > Scribble.CONFIG_MANAGER.getConfig().editHistorySize) {
            this.commands.removeFirst();
            --this.index;
        }
    }

    public boolean canUndo() {
        return this.index > 0;
    }

    public boolean canRedo() {
        return this.index < this.commands.size();
    }

    public void tryUndo() {
        if (!this.canUndo()) {
            return;
        }
        --this.index;
        Command command = this.commands.get(this.index);
        command.rollback(this.listener);
    }

    public void tryRedo() {
        if (!this.canRedo()) {
            return;
        }
        Command command = this.commands.get(this.index);
        command.execute(this.listener);
        ++this.index;
    }
}

