/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.scribble.gui.edit;

import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.chrr.scribble.KeyboardUtil;
import me.chrr.scribble.Scribble;
import me.chrr.scribble.book.RichText;
import net.minecraft.class_11908;
import net.minecraft.class_124;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_5348;
import net.minecraft.class_7530;
import net.minecraft.class_7533;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class RichEditBox
extends class_7530 {
    private final Supplier<class_3545<class_124, Set<class_124>>> formatSupplier;
    private final BiConsumer<@Nullable class_124, Set<class_124>> formatListener;
    private RichText richText;

    public RichEditBox(class_327 textRenderer, int width, Supplier<class_3545<class_124, Set<class_124>>> formatSupplier, BiConsumer<@Nullable class_124, Set<class_124>> formatListener) {
        super(textRenderer, width);
        this.formatSupplier = formatSupplier;
        this.formatListener = formatListener;
    }

    public void method_44415(Consumer<String> changeListener) {
        super.method_44415(text -> changeListener.accept(this.method_44421()));
    }

    public void sendUpdateFormat() {
        if (this.formatListener != null) {
            class_7530.class_7531 selection = this.method_44427();
            class_3545<@Nullable class_124, Set<class_124>> format = this.richText.getCommonFormat(selection.comp_862(), selection.comp_863());
            this.formatListener.accept((class_124)format.method_15442(), (Set)format.method_15441());
        }
    }

    public void applyFormatting(class_124 formatting, boolean active) {
        class_7530.class_7531 selection = this.method_44427();
        int start = selection.comp_862();
        int end = selection.comp_863();
        RichText result = formatting.method_542() ? (active ? this.richText.applyFormatting(start, end, null, Set.of(formatting), Set.of()) : this.richText.applyFormatting(start, end, null, Set.of(), Set.of(formatting))) : this.richText.applyFormatting(start, end, formatting, Set.of(), Set.of());
        if (!this.exceedsMaxLines(result)) {
            this.richText = result;
            this.field_39515 = this.richText.getPlainText();
            this.method_44440();
            this.sendUpdateFormat();
        }
    }

    public void method_44414(String text, boolean allowOverflow) {
        String truncated = this.method_44423(text);
        RichText richText = RichText.fromFormattedString(truncated);
        if (allowOverflow || !this.exceedsMaxLines(richText)) {
            this.richText = richText;
            this.field_39515 = richText.getPlainText();
            this.field_39517 = this.field_39516 = this.field_39515.length();
            this.method_44440();
            this.sendUpdateFormat();
        }
    }

    public String method_44421() {
        return this.richText.getAsFormattedString();
    }

    public void setRichTextWithoutUpdating(RichText richText) {
        this.richText = richText;
        this.field_39515 = richText.getPlainText();
    }

    public void method_44420(String string) {
        RichText result;
        if ((string = string.replaceAll(class_124.field_1070.toString(), "")).isEmpty() && !this.method_44435()) {
            return;
        }
        class_3545<class_124, Set<class_124>> style = this.formatSupplier.get();
        RichText replacement = class_124.method_539((String)string).equals(string) ? new RichText(string, (class_124)style.method_15442(), (Set)style.method_15441()) : RichText.fromFormattedString(string);
        class_7530.class_7531 substring = this.method_44427();
        int start = substring.comp_862();
        int end = substring.comp_863();
        RichText richText = result = this.method_44435() ? this.richText.replace(start, end, replacement) : this.richText.insert(start, replacement);
        if (!this.exceedsMaxLines(result)) {
            this.richText = result;
            this.field_39515 = this.richText.getPlainText();
            this.field_39517 = this.field_39516 = start + replacement.getLength();
            this.method_44440();
            this.sendUpdateFormat();
        }
    }

    public void method_44425(int offset) {
        if (offset != 0) {
            int cursorX = this.field_39513.method_27525((class_5348)this.richText.subText(this.method_44439().comp_862(), this.field_39516)) + 2;
            class_7530.class_7531 substring = this.method_44431(offset);
            int col = this.field_39513.method_1714((class_5348)this.richText.subText(substring.comp_862(), substring.comp_863()), cursorX).getString().length();
            this.method_44412(class_7533.field_39535, substring.comp_862() + col);
        }
    }

    public void method_44410(double x, double y) {
        int cursorX = class_3532.method_15357((double)x);
        Objects.requireNonNull(this.field_39513);
        int line = class_3532.method_15357((double)(y / 9.0));
        class_7530.class_7531 substring = (class_7530.class_7531)this.field_39514.get(class_3532.method_15340((int)line, (int)0, (int)(this.field_39514.size() - 1)));
        int col = this.field_39513.method_1714((class_5348)this.richText.subText(substring.comp_862(), substring.comp_863()), cursorX).getString().length();
        this.method_44412(class_7533.field_39535, substring.comp_862() + col);
    }

    public void method_44412(class_7533 movement, int amount) {
        super.method_44412(movement, amount);
        this.sendUpdateFormat();
    }

    public boolean method_44428(class_11908 input) {
        boolean ctrlNoAlt;
        boolean keepFormatting = Scribble.CONFIG_MANAGER.getConfig().copyFormattingCodes ^ input.method_74239();
        boolean bl = ctrlNoAlt = input.method_74240() && !input.method_74238();
        if (ctrlNoAlt && (KeyboardUtil.isKey(input.comp_4795(), "C") || KeyboardUtil.isKey(input.comp_4795(), "X"))) {
            String text = this.method_44436();
            if (!keepFormatting) {
                text = class_124.method_539((String)text);
            }
            class_310.method_1551().field_1774.method_1455(text);
            if (KeyboardUtil.isKey(input.comp_4795(), "X")) {
                this.method_44420("");
            }
            return true;
        }
        if (ctrlNoAlt && KeyboardUtil.isKey(input.comp_4795(), "V")) {
            String text = class_310.method_1551().field_1774.method_1460();
            if (!keepFormatting) {
                text = class_124.method_539((String)text);
            }
            this.method_44420(text);
            return true;
        }
        if (input.method_74241()) {
            boolean handled = super.method_44428(input);
            this.sendUpdateFormat();
            return handled;
        }
        return super.method_44428(input);
    }

    protected void method_44441() {
        this.field_39514.clear();
        if (this.field_39515.isEmpty()) {
            this.field_39514.add(new class_7530.class_7531(0, 0));
            return;
        }
        MutableInt current = new MutableInt();
        this.field_39513.method_27527().method_29971((class_5348)this.richText, this.field_39520, class_2583.field_24360, (line, continued) -> {
            String content = line.getString();
            int start = current.getValue();
            int end = start + content.length();
            this.field_39514.add(new class_7530.class_7531(start, end));
            if (this.field_39515.length() > end) {
                char c;
                end += (c = this.field_39515.charAt(end)) == '\n' || c == ' ' ? 1 : 0;
            }
            current.setValue(end);
        });
    }

    public String method_44436() {
        class_7530.class_7531 substring = this.method_44427();
        return this.richText.subText(substring.comp_862(), substring.comp_863()).getAsFormattedString();
    }

    private boolean exceedsMaxLines(RichText text) {
        return this.method_71518() && this.field_39513.method_27527().method_27495((class_5348)text, this.field_39520, class_2583.field_24360).size() > this.field_60450;
    }

    public RichText getRichText() {
        return this.richText;
    }
}

