/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.gui.widget.entries;

import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.gui.widget.ModListWidget;
import com.terraformersmc.modmenu.gui.widget.UpdateAvailableBadge;
import com.terraformersmc.modmenu.gui.widget.entries.ParentEntry;
import com.terraformersmc.modmenu.util.DrawingUtil;
import com.terraformersmc.modmenu.util.mod.Mod;
import com.terraformersmc.modmenu.util.mod.ModBadgeRenderer;
import java.util.Objects;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_10799;
import net.minecraft.class_11876;
import net.minecraft.class_11909;
import net.minecraft.class_156;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4280;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_9848;

public class ModListEntry
extends class_4280.class_4281<ModListEntry> {
    public static final class_2960 UNKNOWN_ICON = class_2960.method_60656((String)"textures/misc/unknown_pack.png");
    private static final class_2960 MOD_CONFIGURATION_ICON = class_2960.method_60655((String)"modmenu", (String)"textures/gui/mod_configuration.png");
    private static final class_2960 ERROR_ICON = class_2960.method_60656((String)"world_list/error");
    private static final class_2960 ERROR_HIGHLIGHTED_ICON = class_2960.method_60656((String)"world_list/error_highlighted");
    protected final class_310 client;
    public final Mod mod;
    protected final ModListWidget list;
    protected class_2960 iconLocation;
    protected static final int FULL_ICON_SIZE = 32;
    protected static final int COMPACT_ICON_SIZE = 19;
    protected long sinceLastClick;
    protected int yOffset = 0;

    public ModListEntry(Mod mod, ModListWidget list) {
        this.mod = mod;
        this.list = list;
        this.client = class_310.method_1551();
    }

    public class_2561 method_37006() {
        return class_2561.method_43470((String)this.mod.getTranslatedName());
    }

    public void method_25343(class_332 drawContext, int mouseX, int mouseY, boolean hovered, float delta) {
        class_5250 name;
        int x = this.method_46426() + this.getXOffset();
        int y = this.method_73382() + this.getYOffset();
        int rowWidth = this.method_73387();
        int iconSize = ModMenuConfig.COMPACT_LIST.getValue() ? 19 : 32;
        String modId = this.mod.getId();
        if ("java".equals(modId)) {
            DrawingUtil.drawRandomVersionBackground(this.mod, drawContext, x, y, iconSize, iconSize);
        }
        drawContext.method_25291(class_10799.field_56883, this.getIconTexture(), x, y, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize, class_9848.method_61317((float)1.0f));
        class_5250 trimmedName = name = class_2561.method_43470((String)this.mod.getTranslatedName());
        int maxNameWidth = rowWidth - iconSize - 3;
        class_327 font = this.client.field_1772;
        if (font.method_27525((class_5348)name) > maxNameWidth) {
            class_5348 ellipsis = class_5348.method_29430((String)"...");
            trimmedName = class_5348.method_29433((class_5348[])new class_5348[]{font.method_1714((class_5348)name, maxNameWidth - font.method_27525(ellipsis)), ellipsis});
        }
        drawContext.method_35720(font, class_2477.method_10517().method_30934((class_5348)trimmedName), x + iconSize + 3, y + 1, -1);
        int updateBadgeXOffset = 0;
        if (ModMenuConfig.UPDATE_CHECKER.getValue() && !ModMenuConfig.DISABLE_UPDATE_CHECKER.getValue().contains(modId) && (this.mod.hasUpdate() || this.mod.getChildHasUpdate())) {
            UpdateAvailableBadge.renderBadge(drawContext, x + iconSize + 3 + font.method_27525((class_5348)name) + 2, y);
            updateBadgeXOffset = 11;
        }
        if (!ModMenuConfig.HIDE_BADGES.getValue()) {
            new ModBadgeRenderer(x + iconSize + 3 + font.method_27525((class_5348)name) + 2 + updateBadgeXOffset, y, x + rowWidth, this.mod, this.list.getParent()).draw(drawContext, mouseX, mouseY);
        }
        if (!ModMenuConfig.COMPACT_LIST.getValue()) {
            String summary = this.mod.getSummary();
            Objects.requireNonNull(this.client.field_1772);
            DrawingUtil.drawWrappedString(drawContext, summary, x + iconSize + 3 + 4, y + 9 + 2, rowWidth - iconSize - 7, 2, -8355712);
        } else {
            String string = this.mod.getPrefixedVersion();
            Objects.requireNonNull(this.client.field_1772);
            DrawingUtil.drawWrappedString(drawContext, string, x + iconSize + 3, y + 9 + 2, rowWidth - iconSize - 7, 2, -8355712);
        }
        if (!(this instanceof ParentEntry) && ModMenuConfig.QUICK_CONFIGURE.getValue() && (this.list.getParent().getModHasConfigScreen(modId) || this.list.getParent().modScreenErrors.containsKey(modId))) {
            int textureSize;
            int n = textureSize = ModMenuConfig.COMPACT_LIST.getValue() ? 152 : 256;
            if (((Boolean)this.client.field_1690.method_42446().method_41753()).booleanValue() || hovered) {
                boolean hoveringIcon;
                drawContext.method_25294(x, y, x + iconSize, y + iconSize, -1601138544);
                boolean bl = hoveringIcon = mouseX - x < iconSize;
                if (this.list.getParent().modScreenErrors.containsKey(modId)) {
                    drawContext.method_52706(class_10799.field_56883, hoveringIcon ? ERROR_HIGHLIGHTED_ICON : ERROR_ICON, x, y, iconSize, iconSize);
                } else {
                    int v = hoveringIcon ? iconSize : 0;
                    drawContext.method_25291(class_10799.field_56883, MOD_CONFIGURATION_ICON, x, y, 0.0f, (float)v, iconSize, iconSize, textureSize, textureSize, class_9848.method_61317((float)1.0f));
                }
                if (hoveringIcon) {
                    drawContext.method_74037(this.method_72784() ? class_11876.field_62455 : class_11876.field_62459);
                }
            }
        }
    }

    public boolean method_25402(class_11909 click, boolean doubleClick) {
        this.list.select(this);
        if (ModMenuConfig.QUICK_CONFIGURE.getValue() && this.list.getParent().getModHasConfigScreen(this.mod.getId())) {
            int iconSize;
            int n = iconSize = ModMenuConfig.COMPACT_LIST.getValue() ? 19 : 32;
            if (click.comp_4798() - (double)this.list.method_25342() <= (double)iconSize) {
                this.openConfig();
            } else if (class_156.method_658() - this.sinceLastClick < 250L) {
                this.openConfig();
            }
        }
        this.sinceLastClick = class_156.method_658();
        return true;
    }

    public void openConfig() {
        this.list.getParent().safelyOpenConfigScreen(this.mod.getId());
    }

    public Mod getMod() {
        return this.mod;
    }

    public class_2960 getIconTexture() {
        if (this.iconLocation == null) {
            this.iconLocation = class_2960.method_60655((String)"modmenu", (String)(this.mod.getId() + "_icon"));
            class_1043 icon = this.mod.getIcon(this.list.getFabricIconHandler(), 64 * (Integer)this.client.field_1690.method_42474().method_41753());
            icon.method_4527(false, false);
            this.client.method_1531().method_4616(this.iconLocation, (class_1044)icon);
        }
        return this.iconLocation;
    }

    public int getXOffset() {
        return 0;
    }

    public void setYOffset(int offset) {
        this.yOffset = offset;
    }

    public int getYOffset() {
        return this.yOffset;
    }
}

